﻿var questionsSelector = {
    context: $("#QuestionsSelector"),
    datatable: null,
    showSystemVariables: true,
    openEndsType: "Yes",
    showFilters: false,
    ignorePiiSelectionRestriction: false,
    limitRowCount: 10,
    questionSelectorType: 1,
    initializeDataTable: function () {
        var selectedQuestions = $(".v-selectedQuestions", questionsSelector.context).val();

        if (!selectedQuestions || selectedQuestions.length == 0)
        {
            var extractionWizard = a4.parent().extractionWizard;
            var importWizard = a4.parent().importWizard;

            if (typeof extractionWizard !== "undefined")
            {
                if (extractionWizard.currentData != null && extractionWizard.currentData.length > 0) {
                    selectedQuestions = _.map(JSON.parse(extractionWizard.currentData), function (v) {
                        return {
                            Name: v.Name,
                            IsSystem: v.IsSystemVariable
                        };
                    });
                }
            }
            else if (typeof importWizard !== "undefined")
            {
                if (importWizard.mappingData != null && importWizard.mappingData.length > 0) {
                    selectedQuestions = _.pluck(importWizard.mappingData, "InterviewerFieldName").join(",");
                }
            }
        }

        this.datatable = $(".h-questions-table", questionsSelector.context).a4datatable({            
            ajaxAction: a4.getProjectAction("GetQuestions", "Shared"),
            ajaxParams: {
                "includeSystemVariables": questionsSelector.showSystemVariables,
                "openEndsIncludedType": questionsSelector.openEndsType,
                "questionSelectorType": questionsSelector.questionSelectorType,
                "ignorePiiSelectionRestriction": questionsSelector.ignorePiiSelectionRestriction,
                "dtsType": a4.parent().$("#DtsType").val(), 
            },            
            columns: [
                { "Name": "QuestionNumber", "Title": resources.QuestionNumber, "Data": "QuestionNumber" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Key": true },
                { "Name": "LongLabel", "Title": resources.Text, "Data": "LongLabel" }
            ],
            height: "full",
            stateKey: "QuestionsSelector",
            allowRowSelection: "[IsPersonalInformation] == 0 || voxco.security.hasFeature('CAN_READ_PII') || questionsSelector.ignorePiiSelectionRestriction",
            rememberRowSelection: true,
            limitRowSelection: questionsSelector.limitRowCount,
            selectedRows: selectedQuestions,
            style: "compact",
            quickFilter: questionsSelector.showFilters && {
                "AlwaysVisible": true,
                "IncludeSelectedStates": true,
                "Items": [
                    { "Label": resources.System, "AjaxParams": { "onlyQuestions": false, "onlyOpenEnds": false, "onlySystem": true }, "Visible": questionsSelector.showSystemVariables },
                    { "Label": resources.Questions, "AjaxParams": { "onlyQuestions": true, "onlyOpenEnds": false, "onlySystem": false } },
                    { "Label": resources.OpenEnd, "AjaxParams": { "onlyQuestions": false, "onlyOpenEnds": true, "onlySystem": false } }
                ]
            }
        });
    },
    bindEvents: function () {
        questionsSelector.context.on("click", ".v-confirmButton", function () {
            var items = questionsSelector.datatable.a4datatable("getSelectedItems");

            var originalItems = _.filter(items, function (i) { return i.Id == undefined; });

            var newItems = _.filter(items, function (i) { return i.Id !== undefined; }).sort(function (x, y) {
                if (x.BlockPosition !== y.BlockPosition)
                    return x.BlockPosition - y.BlockPosition;

                if (x.QuestionPosition !== y.QuestionPosition)
                    return x.QuestionPosition - y.QuestionPosition;

                if (x.ColPos !== y.ColPos)
                    return x.ColPos - y.ColPos;

                if (x.RowPos !== y.RowPos)
                    return x.RowPos - y.RowPos;

                return x.Id - y.Id;
            });

            var selectedItems = originalItems.concat(newItems);
            var selectedQuestions = _.pluck(selectedItems, "Name").join(",");

            $(".v-selectedQuestions").val(selectedQuestions);
            $(".v-confirmed", questionsSelector.context).val("true");

            var extractionWizard = a4.parent().extractionWizard;
            if (typeof extractionWizard !== "undefined") {
                extractionWizard.selectQuestions(_.map(selectedItems, function (i) {
                    return {
                        Name: i.Name,
                        IsSystemVariable: i.IsSystem
                    };
                }));
            }

            modalDialog.close(selectedQuestions);
        });

        questionsSelector.context.on("click", ".h-selectAllRows", function () {
            var params = {
                includeSystemVariables: questionsSelector.showSystemVariables,
                openEndsIncludedType: questionsSelector.openEndsType,
                questionSelectorType: questionsSelector.questionSelectorType,
                ignorePiiSelectionRestriction: questionsSelector.ignorePiiSelectionRestriction,
                dtsType: a4.parent().$("#DtsType").val(),
            }

            a4.callServerMethod(a4.getProjectAction("GetQuestions", "Shared"), params,
            function (result) {
                questionsSelector.datatable.a4datatable("option", "selectedRows", result.aaData);
            });
        });

        questionsSelector.context.on("click", ".h-unselectAllRows", function () {
            questionsSelector.datatable.a4datatable("option", "selectedRows", []);
            $(".h-selectAll").addClass("fa-square-o").removeClass("fa-check-square");
        });
    }
}

$(document).ready(function () {
    if (questionsSelector.context.length > 0) {
        var limit = parseInt($("#LimitCount", questionsSelector.context).val(), 10);
        questionsSelector.limitRowCount = (limit > 0) ? limit : null;

        questionsSelector.showFilters = ($("#ShowFilters", questionsSelector.context).val().toLowerCase() == "true");
        questionsSelector.showSystemVariables = ($("#ShowSystemVariables", questionsSelector.context).val().toLowerCase() == "true");
        questionsSelector.openEndsType = $("#OpenEndsIncludedType", questionsSelector.context).val();
        questionsSelector.questionSelectorType = $("#QuestionSelectorType", questionsSelector.context).val();
        questionsSelector.ignorePiiSelectionRestriction = ($("#IgnorePiiSelectionRestriction", questionsSelector.context).val().toLowerCase() == "true");

        questionsSelector.initializeDataTable();
        questionsSelector.bindEvents();
    }
});